/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import jakarta.enterprise.context.RequestScoped;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.openejb.BeanContext;
import org.apache.openejb.cdi.CdiAppContextsService;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ThreadContextListener;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.web.context.ServletRequestContext;

public class RequestScopedThreadContextListener
implements ThreadContextListener {
    private static Logger LOG = Logger.getInstance(LogCategory.OPENEJB.createChild("ThreadContext"), "org.apache.openejb.cdi");

    @Override
    public void contextEntered(ThreadContext oldContext, ThreadContext newContext, boolean propagateTx) {
        BeanContext beanContext;
        WebBeansContext webBeansContext;
        if (LOG.isDebugEnabled()) {
            LOG.debug("ThreadContextListener contextEntered: oldContext=" + oldContext + ", newContext=" + newContext + ", from=" + RequestScopedThreadContextListener.fromStackTrace(new Exception()));
        }
        if ((webBeansContext = (beanContext = newContext.getBeanContext()).getModuleContext().getAppContext().getWebBeansContext()) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ThreadContextListener contextEntered: webBeansContext is null");
            }
            return;
        }
        ContextsService contextsService = webBeansContext.getContextsService();
        ServletRequestContext requestContext = ((CdiAppContextsService)((Object)CdiAppContextsService.class.cast(contextsService))).getRequestContext(false);
        if (requestContext == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ThreadContextListener contextEntered: requestContext is null, creating new request scope");
            }
            contextsService.startContext(RequestScoped.class, CdiAppContextsService.EJB_REQUEST_EVENT);
            newContext.set(DestroyContext.class, new DestroyContext(contextsService, newContext));
        }
    }

    @Override
    public void contextExited(ThreadContext exitedContext, ThreadContext reenteredContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ThreadContextListener contextExited: exitedContext=" + exitedContext + ", reenteredContext=" + reenteredContext + ", from=" + RequestScopedThreadContextListener.fromStackTrace(new Exception()));
        }
        if (exitedContext == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ThreadContextListener contextExited: exitedContext is null, not destroying RequestScope");
            }
            return;
        }
        DestroyContext destroyContext = exitedContext.get(DestroyContext.class);
        if (destroyContext == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ThreadContextListener contextExited: destroyContext is null, not destroying RequestScope");
            }
            return;
        }
        if (destroyContext.threadContext != exitedContext) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ThreadContextListener contextExited: destroyContext does not match exited context, not destroying RequestScope");
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("ThreadContextListener contextExited: destroying RequestScope");
        }
        destroyContext.contextsService.endContext(RequestScoped.class, CdiAppContextsService.EJB_REQUEST_EVENT);
        destroyContext.contextsService.removeThreadLocals();
    }

    private static String fromStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    private static final class DestroyContext {
        private final ContextsService contextsService;
        private final ThreadContext threadContext;

        private DestroyContext(ContextsService contextsService, ThreadContext threadContext) {
            this.contextsService = contextsService;
            this.threadContext = threadContext;
        }
    }
}

