/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui.dialogs;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.uima.taeconfigurator.InternalErrorCDE;
import org.apache.uima.taeconfigurator.TAEConfiguratorPlugin;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AbstractDialog;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class ResourcePickerDialog
extends AbstractDialog {
    protected Tree resourcesUI;
    protected TreeColumn resourcesUIc1;
    protected TreeColumn resourcesUIc2;
    public IResource pickedResource;
    protected Object[] result;
    private static final Comparator resourceComparator = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            IResource r0 = (IResource)arg0;
            IResource r1 = (IResource)arg1;
            return r0.getName().compareTo(r1.getName());
        }
    };

    public ResourcePickerDialog(Shell shell) {
        super(shell, "Select a File", "Use this panel to select a file in the Workspace");
    }

    private void populate(TreeItem parent, IResource[] resources) {
        Arrays.sort(resources, resourceComparator);
        for (int i = 0; i < resources.length; ++i) {
            TreeItem item = new TreeItem(parent, 0);
            IResource r = resources[i];
            item.setText(r.getName());
            item.setData((Object)r);
            if (!(r instanceof IContainer)) continue;
            new TreeItem(item, 0);
        }
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite mainArea = (Composite)super.createDialogArea(parent);
        this.resourcesUI = this.newTree(mainArea, 4);
        ((GridData)this.resourcesUI.getLayoutData()).heightHint = 400;
        this.resourcesUIc1 = new TreeColumn(this.resourcesUI, 16384);
        this.resourcesUIc2 = new TreeColumn(this.resourcesUI, 16384);
        this.setupResourcesByLocation();
        return mainArea;
    }

    protected void setupResourcesByLocation() {
        this.resourcesUI.removeAll();
        this.resourcesUI.removeListener(17, (Listener)this);
        this.resourcesUI.removeListener(13, (Listener)this);
        this.resourcesUIc1.setWidth(500);
        this.resourcesUIc2.setWidth(0);
        this.resourcesUI.setHeaderVisible(false);
        TreeItem topItem = new TreeItem(this.resourcesUI, 0);
        topItem.setText("Workspace");
        IWorkspaceRoot root = TAEConfiguratorPlugin.getWorkspace().getRoot().getWorkspace().getRoot();
        try {
            IResource[] projects = root.members();
            this.populate(topItem, projects);
        }
        catch (CoreException e) {
            throw new InternalErrorCDE("unhandled exception", e);
        }
        topItem.setExpanded(true);
        this.resourcesUI.addListener(17, (Listener)this);
        this.resourcesUI.addListener(13, (Listener)this);
    }

    @Override
    public void handleEvent(Event event) {
        if (event.widget == this.resourcesUI && event.type == 17) {
            TreeItem expandedNode = (TreeItem)event.item;
            TreeItem maybeDummy = expandedNode.getItem(0);
            if (null == maybeDummy.getData()) {
                maybeDummy.dispose();
                IResource parentResource = (IResource)expandedNode.getData();
                try {
                    this.populate(expandedNode, ((IContainer)parentResource).members());
                }
                catch (CoreException e) {
                    throw new InternalErrorCDE("unhandled exception", e);
                }
            }
        } else if (event.widget == this.resourcesUI && event.type == 13) {
            this.copyValuesFromGUI();
        }
        super.handleEvent(event);
    }

    @Override
    public void copyValuesFromGUI() {
        if (this.resourcesUI.getSelectionCount() > 0) {
            IFile[] iFileArray;
            IPath ipath;
            this.pickedResource = (IResource)this.resourcesUI.getSelection()[0].getData();
            IPath iPath = ipath = null == this.pickedResource ? null : this.pickedResource.getFullPath();
            if (null == ipath || 2 > ipath.segmentCount()) {
                iFileArray = null;
            } else {
                IFile[] iFileArray2 = new IFile[1];
                iFileArray = iFileArray2;
                iFileArray2[0] = TAEConfiguratorPlugin.getWorkspace().getRoot().getFile(ipath);
            }
            this.result = iFileArray;
        }
    }

    @Override
    public void enableOK() {
        if (0 < this.resourcesUI.getSelectionCount() && this.resourcesUI.getSelection()[0].getData() instanceof IFile) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public Object[] getResult() {
        return this.result;
    }

    public void setResult(List aResult) {
        if (null == aResult) {
            this.result = null;
        } else {
            this.result = new Object[aResult.size()];
            aResult.toArray(this.result);
        }
    }
}

