/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.componentmodel;

import com.strobel.annotations.NotNull;
import com.strobel.componentmodel.FrugalKeyMap;
import com.strobel.componentmodel.Key;
import com.strobel.componentmodel.PairKeyMap;
import com.strobel.core.VerifyArgument;

final class SingleKeyMap<V>
implements FrugalKeyMap {
    private final int _keyIndex;
    private final V _value;

    SingleKeyMap(int keyIndex, V value) {
        this._keyIndex = keyIndex;
        this._value = value;
    }

    @Override
    @NotNull
    public final <V> FrugalKeyMap plus(@NotNull Key<V> key, @NotNull V value) {
        VerifyArgument.notNull(key, "key");
        VerifyArgument.notNull(value, "value");
        if (key.hashCode() == this._keyIndex) {
            return new SingleKeyMap<V>(key.hashCode(), value);
        }
        return new PairKeyMap(this._keyIndex, this._value, key.hashCode(), value);
    }

    @Override
    @NotNull
    public final <V> FrugalKeyMap minus(@NotNull Key<V> key) {
        VerifyArgument.notNull(key, "key");
        if (key.hashCode() == this._keyIndex) {
            return EMPTY;
        }
        return this;
    }

    @Override
    public final <V> V get(@NotNull Key<V> key) {
        VerifyArgument.notNull(key, "key");
        if (key.hashCode() == this._keyIndex) {
            return this._value;
        }
        return null;
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }
}

