/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource.caching.version;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.caching.IStaticCacheableResource;
import org.apache.wicket.request.resource.caching.version.IResourceVersion;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;

public class RequestCycleCachedResourceVersion
implements IResourceVersion {
    private static final MetaDataKey<Map<Serializable, String>> CACHE_KEY = new MetaDataKey<Map<Serializable, String>>(){
        private static final long serialVersionUID = 1L;
    };
    private final IResourceVersion delegate;

    public RequestCycleCachedResourceVersion(IResourceVersion delegate) {
        this.delegate = (IResourceVersion)Args.notNull((Object)delegate, (String)"delegate");
    }

    @Override
    public String getVersion(IStaticCacheableResource resource) {
        RequestCycle requestCycle = ThreadContext.getRequestCycle();
        HashMap cache = null;
        Serializable key = null;
        if (requestCycle != null) {
            cache = requestCycle.getMetaData(CACHE_KEY);
            key = resource.getCacheKey();
            if (cache == null) {
                cache = Generics.newHashMap();
                requestCycle.setMetaData((MetaDataKey)CACHE_KEY, cache);
            } else if (cache.containsKey(key)) {
                return (String)cache.get(key);
            }
        }
        String version = this.delegate.getVersion(resource);
        if (cache != null && key != null) {
            cache.put((Serializable)key, (String)version);
        }
        return version;
    }

    @Override
    public Pattern getVersionPattern() {
        return this.delegate.getVersionPattern();
    }
}

