/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.bean.validation;

import java.util.Locale;
import javax.validation.MessageInterpolator;
import org.apache.wicket.Session;
import org.apache.wicket.util.lang.Args;

public class SessionLocaleInterpolator
implements MessageInterpolator {
    private final MessageInterpolator delegate;

    public SessionLocaleInterpolator(MessageInterpolator delegate) {
        Args.notNull((Object)delegate, (String)"delegate");
        this.delegate = delegate;
    }

    public String interpolate(String messageTemplate, MessageInterpolator.Context context) {
        Locale locale = this.getLocale();
        if (locale != null) {
            return this.interpolate(messageTemplate, context, locale);
        }
        return this.delegate.interpolate(messageTemplate, context);
    }

    public String interpolate(String message, MessageInterpolator.Context context, Locale locale) {
        return this.delegate.interpolate(message, context, locale);
    }

    private Locale getLocale() {
        return Session.exists() ? Session.get().getLocale() : null;
    }
}

